/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.INpc;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathWorldListener;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.IChatMessages;
import noppes.npcs.LogWriter;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcDamageSource;
import noppes.npcs.Server;
import noppes.npcs.VersionCompatibility;
import noppes.npcs.ai.CombatHandler;
import noppes.npcs.ai.EntityAIAnimation;
import noppes.npcs.ai.EntityAIBustDoor;
import noppes.npcs.ai.EntityAIFindShade;
import noppes.npcs.ai.EntityAIJob;
import noppes.npcs.ai.EntityAIRole;
import noppes.npcs.ai.EntityAITransform;
import noppes.npcs.ai.EntityAIWander;
import noppes.npcs.ai.EntityAIWorldLines;
import noppes.npcs.ai.FlyingMoveHelper;
import noppes.npcs.ai.attack.EntityAIAvoidTarget;
import noppes.npcs.ai.attack.EntityAICommanderTarget;
import noppes.npcs.ai.attack.EntityAICustom;
import noppes.npcs.ai.attack.EntityAIDodge;
import noppes.npcs.ai.attack.EntityAIHitAndRun;
import noppes.npcs.ai.attack.EntityAINoTactic;
import noppes.npcs.ai.attack.EntityAIOnslaught;
import noppes.npcs.ai.attack.EntityAIPounceTarget;
import noppes.npcs.ai.attack.EntityAIStalkTarget;
import noppes.npcs.ai.attack.EntityAISurround;
import noppes.npcs.ai.movement.EntityAIFollow;
import noppes.npcs.ai.movement.EntityAIMoveIndoors;
import noppes.npcs.ai.movement.EntityAIMovingPath;
import noppes.npcs.ai.movement.EntityAIReturn;
import noppes.npcs.ai.movement.EntityAISprintToTarget;
import noppes.npcs.ai.movement.EntityAIWaterNav;
import noppes.npcs.ai.selector.NPCAttackSelector;
import noppes.npcs.ai.target.EntityAIClearTarget;
import noppes.npcs.ai.target.EntityAIClosestTarget;
import noppes.npcs.ai.target.EntityAILook;
import noppes.npcs.ai.target.EntityAIOwnerHurtByTarget;
import noppes.npcs.ai.target.EntityAIOwnerHurtTarget;
import noppes.npcs.ai.target.EntityAIWatchClosest;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.constants.AnimationType;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IProjectile;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.item.INPCToolItem;
import noppes.npcs.api.mixin.entity.IEntityLivingBaseMixin;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.NPCWrapper;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.client.model.animation.AnimationFrameConfig;
import noppes.npcs.client.model.part.ModelData;
import noppes.npcs.constants.EnumAnimationStages;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.data.DataTransform;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.entity.data.DataAI;
import noppes.npcs.entity.data.DataAbilities;
import noppes.npcs.entity.data.DataAdvanced;
import noppes.npcs.entity.data.DataAnimation;
import noppes.npcs.entity.data.DataDisplay;
import noppes.npcs.entity.data.DataInventory;
import noppes.npcs.entity.data.DataScript;
import noppes.npcs.entity.data.DataStats;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.items.ItemSoulstoneFilled;
import noppes.npcs.reflection.world.WorldReflection;
import noppes.npcs.roles.JobBard;
import noppes.npcs.roles.JobFollower;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.GameProfileAlt;
import noppes.npcs.util.Util;
import noppes.npcs.util.ValueUtil;

public abstract class EntityNPCInterface
extends EntityCreature
implements IEntityAdditionalSpawnData,
ICommandSender,
IRangedAttackMob,
IAnimals,
INpc {
    public static FakePlayer ChatEventPlayer;
    public static FakePlayer CommandPlayer;
    public static FakePlayer GenericPlayer;
    public static GameProfileAlt ChatEventProfile;
    public static GameProfileAlt CommandProfile;
    public static GameProfileAlt GenericProfile;
    protected static DataParameter<Integer> Animation;
    public static final DataParameter<Boolean> Attacking;
    private static final DataParameter<Integer> FactionData;
    private static final DataParameter<Boolean> Interacting;
    private static final DataParameter<Boolean> IsDead;
    private static final DataParameter<String> JobData;
    private static final DataParameter<String> RoleData;
    private static final DataParameter<Boolean> Walking;
    public static final DataParameter<Float> AimRotationYaw;
    public DataAbilities abilities;
    public DataDisplay display;
    public DataStats stats;
    public DataAI ais;
    public DataInventory inventory;
    public DataAdvanced advanced;
    public DataScript script;
    public DataAnimation animation;
    public int animationStart = 0;
    public int currentAnimation = 0;
    public float baseWidth = 0.6f;
    public float baseHeight = 1.9f;
    public float baseEyeHeight = 1.615f;
    public float eyeHeight = 1.615f;
    public BossInfoServer bossInfo;
    public CombatHandler combatHandler;
    public int[] dialogs = new int[0];
    public Faction faction;
    public double field_20061_w;
    public double field_20062_v;
    public double field_20063_u;
    public double field_20064_t;
    public double field_20065_s;
    public double field_20066_r;
    public boolean hasDied = false;
    public List<EntityLivingBase> interactingEntities = new ArrayList<EntityLivingBase>();
    public EntityAICustom aiAttackTarget;
    public EntityAIAnimation animateAi;
    public EntityAILook lookAi;
    public EntityAIReturn returnAi;
    public Entity lookAt = null;
    public float[] lookPos = new float[]{0.0f, 0.0f};
    public boolean updateLook = false;
    public EntityNPCInterface aiOwnerNPC;
    public boolean aiIsSneak;
    public long killedTime = 0L;
    public int lastInteract = 0;
    public int homeDimensionId;
    public LinkedNpcController.LinkedData linkedData;
    public long linkedLast = 0L;
    public String linkedName = "";
    public IChatMessages messages;
    public int npcVersion = VersionCompatibility.ModRev;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    private double startYPos = -1.0;
    private int taskCount = 1;
    public ResourceLocation textureCloakLocation = null;
    public ResourceLocation textureGlowLocation = null;
    public ResourceLocation textureLocation = null;
    public DataTimers timers;
    public long totalTicksAlive = 0L;
    public DataTransform transform;
    public boolean updateClient = false;
    private boolean wasKilled = false;
    public ICustomNpc<?> wrappedNPC;
    public boolean updateAI = true;
    public Path navigating;
    private long initTime;
    private boolean isOldSneaking;
    public final Map<Entity, double[]> hitboxRiding = new HashMap<Entity, double[]>();

    public EntityNPCInterface(World world) {
        super(world);
        float f;
        this.homeDimensionId = world.field_73011_w.getDimension();
        this.combatHandler = new CombatHandler(this);
        this.bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS);
        this.wrappedNPC = new NPCWrapper<EntityNPCInterface>(this);
        if (!CustomNpcs.DefaultInteractLine.isEmpty()) {
            this.advanced.interactLines.lines.put(0, new Line(CustomNpcs.DefaultInteractLine));
        }
        this.field_70728_aV = 0;
        this.scaleZ = f = 0.9375f;
        this.scaleY = f;
        this.scaleX = f;
        this.faction = this.getFaction();
        this.setFaction(this.faction.id);
        this.func_70105_a(1.0f, 1.0f);
        this.bossInfo.func_186758_d(false);
        this.field_70138_W = this.ais.stepheight;
        this.initTime = System.currentTimeMillis();
        if (!this.func_70613_aW()) {
            CustomNpcs.proxy.checkTexture(this);
        }
        this.animation.tryRunAnimation(AnimationKind.INIT);
        this.field_70771_an = this.ais.getMaxHurtResistantTime();
    }

    public void addInteract(EntityLivingBase entity) {
        if (!this.ais.stopAndInteract || this.isAttacking() || !entity.func_70089_S() || this.func_175446_cd()) {
            return;
        }
        if (this.field_70173_aa - this.lastInteract < 180) {
            this.interactingEntities.clear();
        }
        this.func_70661_as().func_75499_g();
        this.lastInteract = this.field_70173_aa;
        if (!this.interactingEntities.contains(entity)) {
            this.interactingEntities.add(entity);
        }
    }

    public void addRegularEntries() {
        this.returnAi = new EntityAIReturn(this);
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.returnAi);
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIFollow(this));
        if (this.ais.getStandingType() != 1 && this.ais.getStandingType() != 3) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIWatchClosest(this, EntityLivingBase.class, 5.0f));
        }
        this.lookAi = new EntityAILook(this);
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.lookAi);
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIWorldLines(this));
        if (!this.ais.aiDisabled) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIJob(this));
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIRole(this));
        }
        this.animateAi = new EntityAIAnimation(this);
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.animateAi);
        if (this.transform.isValid()) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAITransform(this));
        }
    }

    public void func_184178_b(@Nonnull EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_70024_g(double d, double d1, double d2) {
        if (this.isWalking() && !this.isKilled()) {
            super.func_70024_g(d, d1, d2);
        }
    }

    protected float func_70655_b(@Nonnull DamageSource source, float damage) {
        if (this.advanced.roleInterface instanceof RoleCompanion) {
            damage = ((RoleCompanion)this.advanced.roleInterface).applyArmorCalculations(source, damage);
        }
        return damage;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.abilities = new DataAbilities(this);
        this.display = new DataDisplay(this);
        this.stats = new DataStats(this);
        this.ais = new DataAI(this);
        this.advanced = new DataAdvanced(this);
        this.inventory = new DataInventory(this);
        this.transform = new DataTransform(this);
        this.script = new DataScript(this);
        this.timers = new DataTimers((Object)this);
        if (this.animation == null) {
            this.animation = new DataAnimation((EntityLivingBase)this);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.stats.maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)CustomNpcs.NpcNavRange);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.stats.melee.getStrength());
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a((double)(this.getSpeed() * 2.0f));
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        AnimationConfig anim = this.animation.tryRunAnimation(AnimationKind.ATTACKING);
        if (anim != null) {
            boolean found = false;
            for (AnimationFrameConfig frame : anim.frames.values()) {
                if (!frame.isNowDamage() || frame.damageDelay == 0) continue;
                int time = frame.damageDelay * 50;
                CustomNPCsScheduler.runTack(() -> this.tryAttackEntityAsMob(entity, frame.id), time);
                found = true;
            }
            if (!found) {
                int time = (anim.totalTicks - 1) * 50;
                CustomNPCsScheduler.runTack(() -> this.tryAttackEntityAsMob(entity, anim.frames.size() - 1), time);
            }
            return false;
        }
        return this.tryAttackEntityAsMob(entity, 0);
    }

    private boolean tryAttackEntityAsMob(Entity target, int frameID) {
        if (this.ais.aiDisabled || target == null || !target.func_70089_S()) {
            return false;
        }
        HashSet<Object> entityList = new HashSet<Object>();
        entityList.add(target);
        if (CustomNpcs.ShowCustomAnimation && this.func_70613_aW() && this.animation.isAnimated(AnimationKind.ATTACKING)) {
            List<AxisAlignedBB> aabbs = this.animation.getAnimation().getDamageHitboxes((EntityLivingBase)this, frameID);
            if (aabbs.isEmpty()) {
                double range = this.stats.melee.getRange();
                double minRange = (double)(this.field_70130_N + target.field_70130_N) * 0.425;
                double yaw = Math.abs(Util.instance.getVector3D(this.field_70165_t, this.field_70163_u, this.field_70161_v, target.field_70165_t, target.field_70163_u, target.field_70161_v).getYaw());
                if ((double)this.func_70032_d(target) - minRange > range || yaw > 60.0) {
                    return false;
                }
            } else {
                for (AxisAlignedBB aabb : aabbs) {
                    List list = new ArrayList();
                    try {
                        list = this.field_70170_p.func_72872_a(Entity.class, aabb);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    entityList.addAll(list);
                }
                entityList.remove((Object)this);
            }
        }
        float amount = this.stats.melee.getStrength();
        NpcDamageSource damageSource = new NpcDamageSource("mob", (Entity)this);
        boolean attackEntity = false;
        for (Entity entity : entityList) {
            boolean var4;
            if (this.stats.melee.getDelay() < 10) {
                entity.field_70172_ad = 0;
            }
            if (entity instanceof EntityLivingBase) {
                NpcEvent.MeleeAttackEvent event = new NpcEvent.MeleeAttackEvent(this.wrappedNPC, (EntityLivingBase)entity, amount);
                if (EventHooks.onNPCAttacksMelee(this, event)) {
                    return false;
                }
                amount = event.damage;
            }
            if (var4 = entity.func_70097_a((DamageSource)damageSource, amount)) {
                if (this.getOwner() instanceof EntityPlayer && entity instanceof EntityLivingBase) {
                    EntityUtil.setRecentlyHit((EntityLivingBase)entity);
                }
                if (this.advanced.roleInterface instanceof RoleCompanion) {
                    ((RoleCompanion)this.advanced.roleInterface).attackedEntity();
                }
            }
            if (this.stats.melee.getEffectType() != 0) {
                if (this.stats.melee.getEffectType() != 1) {
                    Potion eff = PotionEffectType.getMCType(this.stats.melee.getEffectType());
                    if (eff != null && entity instanceof EntityLivingBase) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(eff, this.stats.melee.getEffectTime() * 20, this.stats.melee.getEffectStrength()));
                    }
                } else {
                    entity.func_70015_d(this.stats.melee.getEffectTime());
                }
            }
            if (!var4) continue;
            attackEntity = true;
        }
        return attackEntity;
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn) {
        float chance;
        int type;
        boolean isBlocked = false;
        int n = type = damageSourceIn.func_76363_c() || damageSourceIn.func_188404_v() == null ? -1 : 0;
        if (damageSourceIn.func_188404_v() != null) {
            type = 0;
            Vec3d vec3d = damageSourceIn.func_188404_v();
            float angle = (float)Util.instance.getAngles3D(this.field_70165_t, 0.0, this.field_70161_v, vec3d.field_72450_a, 0.0, vec3d.field_72449_c).getYaw() - this.field_70177_z;
            Vec3d vec3d1 = this.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                type = angle < 180.0f ? 1 : 2;
            }
        }
        if (type != -1 && !damageSourceIn.func_76363_c() && (chance = this.stats.getChanceBlockDamage() / 100.0f) > 0.0f && type > 0) {
            if (this.inventory.getProjectile() != null) {
                chance /= 3.0f;
            } else if (type == 1) {
                ItemStack stack;
                ItemStack itemStack = stack = this.inventory.getRightHand() != null ? this.inventory.getRightHand().getMCItemStack() : ItemStack.field_190927_a;
                if (stack.func_77973_b() instanceof ItemSword) {
                    if ((chance *= 1.3333f) < 0.25f) {
                        chance = 0.25f;
                    }
                } else if (stack.func_77973_b() instanceof ItemShield && (chance *= 2.0f) < 0.75f) {
                    chance = 0.75f;
                }
            } else {
                ItemStack stack;
                ItemStack itemStack = stack = this.inventory.getLeftHand() != null ? this.inventory.getLeftHand().getMCItemStack() : ItemStack.field_190927_a;
                if (stack.func_77973_b() instanceof ItemSword) {
                    if ((chance *= 1.1667f) < 0.1f) {
                        chance = 0.1f;
                    }
                } else if (stack.func_77973_b() instanceof ItemShield && (chance *= 1.75f) < 0.5f) {
                    chance = 0.5f;
                }
            }
            float f = this.field_70146_Z.nextFloat();
            isBlocked = chance >= f;
        }
        NpcEvent.NeedBlockDamage event = new NpcEvent.NeedBlockDamage(this.wrappedNPC, damageSourceIn, isBlocked, type);
        EventHooks.onNPCNeedBlockDamage(this, event);
        isBlocked = event.isBlocked && !event.isCanceled();
        return isBlocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_70097_a(@Nonnull DamageSource damagesource, float damage) {
        if (!this.func_70613_aW() || CustomNpcs.FreezeNPCs || damagesource.field_76373_n.equals("inWall")) {
            return false;
        }
        if (damagesource.getClass().getSimpleName().equals("TGDamageSource") && damage < 0.5f) {
            return false;
        }
        if (this.advanced.roleInterface.getEnumType() == RoleType.FOLLOWER && this.advanced.roleInterface.isFollowing() && damagesource == DamageSource.field_76379_h) {
            return false;
        }
        if (damagesource.field_76373_n.equals("outOfWorld") && this.isKilled()) {
            this.reset();
        }
        if (!this.combatHandler.canDamage(damagesource, damage = this.stats.resistances.applyResistance(damagesource, damage))) {
            return false;
        }
        Entity entity = NoppesUtilServer.GetDamageSource(damagesource);
        EntityLivingBase attackingEntity = null;
        if (entity instanceof EntityLivingBase) {
            attackingEntity = (EntityLivingBase)entity;
        }
        if (attackingEntity != null && attackingEntity == this.getOwner()) {
            return false;
        }
        if (attackingEntity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)attackingEntity;
            if (npc.faction.id == this.faction.id) {
                return false;
            }
            if (npc.getOwner() instanceof EntityPlayer) {
                this.field_70718_bc = 100;
            }
        } else if (attackingEntity instanceof EntityPlayer && this.faction.isFriendlyToPlayer((EntityPlayer)attackingEntity)) {
            if (!damagesource.getClass().getSimpleName().equals("TGDamageSource")) {
                ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)damagesource, (float)damage);
            }
            return false;
        }
        NpcEvent.DamagedEvent event = new NpcEvent.DamagedEvent(this.wrappedNPC, entity, damage, damagesource);
        if (EventHooks.onNPCDamaged(this, event)) {
            ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)damagesource, (float)damage);
            return false;
        }
        damage = event.damage;
        if (this.isKilled()) {
            return false;
        }
        if (damagesource.field_76373_n.contains("inFire")) {
            this.func_70015_d(8);
        }
        boolean isHurt = false;
        if (attackingEntity == null) {
            isHurt = this.customAttackEntityFrom(damagesource, damage);
        } else {
            try {
                boolean check = false;
                if (!(attackingEntity instanceof EntityPlayer) || !((EntityPlayer)attackingEntity).field_71075_bZ.field_75102_a) {
                    if (damage > 0.0f) {
                        List inRange = new ArrayList();
                        try {
                            inRange = this.field_70170_p.func_72872_a(EntityNPCInterface.class, this.func_174813_aQ().func_72314_b(32.0, 16.0, 32.0));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        for (EntityNPCInterface npc : inRange) {
                            if (npc.equals((Object)this)) continue;
                            npc.advanced.tryDefendFaction(this.faction.id, (EntityLivingBase)this, attackingEntity);
                        }
                    }
                    if (this.isAttacking()) {
                        if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) > this.func_70032_d((Entity)attackingEntity)) {
                            this.func_70624_b(attackingEntity);
                        }
                        isHurt = this.customAttackEntityFrom(damagesource, damage);
                        check = true;
                    } else if (damage > 0.0f) {
                        this.func_70624_b(attackingEntity);
                    }
                }
                if (!check) {
                    isHurt = this.customAttackEntityFrom(damagesource, damage);
                }
            }
            finally {
                if (event.clearTarget) {
                    this.func_70624_b(null);
                    this.func_70604_c(null);
                }
            }
        }
        if (!this.isKilled()) {
            if (isHurt && damage > 0.0f) {
                this.animation.tryRunAnimation(AnimationKind.HIT);
            } else {
                AnimationConfig anim = this.animation.tryRunAnimation(AnimationKind.BLOCKED);
                if (anim == null && !damagesource.func_76352_a() && attackingEntity != null) {
                    this.func_190629_c(attackingEntity);
                }
            }
        }
        return isHurt;
    }

    private boolean customAttackEntityFrom(DamageSource source, float amount) {
        boolean isDamaged;
        if (!ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (!this.func_70613_aW() || this.func_180431_b(source)) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f || source.func_76347_k() && this.func_70644_a(MobEffects.field_76426_n)) {
            return false;
        }
        float f = amount;
        if (!(source != DamageSource.field_82728_o && source != DamageSource.field_82729_p || this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b())) {
            this.func_184582_a(EntityEquipmentSlot.HEAD).func_77972_a((int)(amount * 4.0f + this.field_70146_Z.nextFloat() * amount * 2.0f), (EntityLivingBase)this);
            amount *= 0.75f;
        }
        boolean isBlockedDamage = false;
        if (amount > 0.0f && this.canBlockDamageSource(source)) {
            this.func_184590_k(amount);
            amount = 0.0f;
            isBlockedDamage = true;
        }
        this.field_70721_aZ = 1.5f;
        boolean damageCanBeDone = true;
        if (this.ais.getMaxHurtResistantTime() != 0 && (float)this.field_70172_ad > (float)this.ais.getMaxHurtResistantTime() / 2.0f) {
            if (amount <= this.field_110153_bc) {
                return false;
            }
            this.func_70665_d(source, amount - this.field_110153_bc);
            this.field_110153_bc = amount;
            damageCanBeDone = false;
        } else {
            this.field_110153_bc = amount;
            this.field_70172_ad = this.ais.getMaxHurtResistantTime();
            this.func_70665_d(source, amount);
            this.field_70737_aN = this.field_70738_aO = 10;
        }
        this.field_70739_aP = 0.0f;
        Entity entity1 = source.func_76346_g();
        if (entity1 != null) {
            EntityTameable entity_wolf;
            if (entity1 instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)entity1);
            }
            if (entity1 instanceof EntityPlayer) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (EntityPlayer)entity1;
            } else if (entity1 instanceof EntityTameable && (entity_wolf = (EntityTameable)entity1).func_70909_n()) {
                this.field_70718_bc = 100;
                this.field_70717_bb = null;
            }
        }
        if (damageCanBeDone) {
            if (isBlockedDamage) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)33);
            } else {
                byte b0 = source == DamageSource.field_76369_e ? (byte)36 : (source.func_76347_k() ? (byte)37 : 2);
                this.field_70170_p.func_72960_a((Entity)this, b0);
            }
            if (source != DamageSource.field_76369_e && !isBlockedDamage) {
                this.func_70018_K();
            }
            if (entity1 != null) {
                double d1 = entity1.field_70165_t - this.field_70165_t;
                double d0 = entity1.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)this.field_70177_z);
                this.func_70653_a(entity1, 0.4f, d1, d0);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.func_70645_a(source);
        } else if (damageCanBeDone) {
            this.playHurtSound(source, isBlockedDamage);
        }
        boolean bl = isDamaged = !isBlockedDamage;
        if (isDamaged) {
            ((IEntityLivingBaseMixin)((Object)this)).npcs$setLastDamageSource(source);
            ((IEntityLivingBaseMixin)((Object)this)).npcs$setLastDamageStamp(this.field_70170_p.func_82737_E());
        }
        if (entity1 instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192127_g.func_192220_a((EntityPlayerMP)entity1, (Entity)this, source, f, amount, isBlockedDamage);
        }
        return isDamaged;
    }

    public void func_82196_d(@Nonnull EntityLivingBase entity, float distanceFactor) {
        if (this.ais.aiDisabled) {
            return;
        }
        ItemStack proj = ItemStackWrapper.MCItem(this.inventory.getProjectile());
        if (proj == null) {
            this.updateAI = true;
            return;
        }
        NpcEvent.RangedLaunchedEvent event = new NpcEvent.RangedLaunchedEvent(this.wrappedNPC, entity, this.stats.ranged.getStrength());
        for (int i = 0; i < this.stats.ranged.getShotCount(); ++i) {
            EntityProjectile projectile = this.shoot(entity, this.stats.ranged.getAccuracy(), proj, distanceFactor == 1.0f);
            projectile.damage = event.damage;
            ItemStack stack = entity.func_184614_ca();
            projectile.callback = (projectile_0, pos, entity1) -> {
                if (stack.func_77973_b() == CustomRegisters.soulstoneFull) {
                    Entity e = ItemSoulstoneFilled.Spawn(null, stack, this.field_70170_p, pos);
                    if (e instanceof EntityLiving && entity1 instanceof EntityLiving) {
                        ((EntityLiving)e).func_70604_c((EntityLivingBase)((EntityLiving)entity1));
                    } else if (e instanceof EntityLivingBase && entity1 instanceof EntityLivingBase) {
                        ((EntityLivingBase)e).func_70604_c((EntityLivingBase)entity1);
                    }
                }
                SoundEvent se = this.stats.ranged.getSoundEvent(entity1 != null ? 1 : 2);
                String sound = this.stats.ranged.getSound(entity1 != null ? 1 : 2);
                float pitch = 1.2f / (this.func_70681_au().nextFloat() * 0.2f + 0.9f);
                if (se != null) {
                    projectile_0.func_184185_a(se, 1.0f, pitch);
                } else if (!sound.isEmpty()) {
                    BlockPos pos1 = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    Server.sendRangedData(this.field_70170_p, pos1, 64, EnumPacketClient.FORCE_PLAY_SOUND, SoundCategory.NEUTRAL.ordinal(), sound, Float.valueOf(pos1.func_177958_n()), Float.valueOf(pos1.func_177956_o()), Float.valueOf(pos1.func_177952_p()), Float.valueOf(1.0f), Float.valueOf(pitch));
                }
                return false;
            };
            SoundEvent se = this.stats.ranged.getSoundEvent(0);
            String sound = this.stats.ranged.getSound(0);
            if (se != null) {
                this.func_184185_a(se, 2.0f, 1.0f);
            } else if (!sound.isEmpty()) {
                BlockPos pos2 = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                Server.sendRangedData(this.field_70170_p, pos2, 64, EnumPacketClient.FORCE_PLAY_SOUND, SoundCategory.NEUTRAL.ordinal(), sound, Float.valueOf(pos2.func_177958_n()), Float.valueOf(pos2.func_177956_o()), Float.valueOf(pos2.func_177952_p()), Float.valueOf(2.0f), Float.valueOf(1.0f));
            }
            event.projectiles.add((IProjectile)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)projectile));
        }
        EventHooks.onNPCRangedLaunched(this, event);
    }

    private double calculateStartYPos(BlockPos pos) {
        BlockPos startPos = this.ais.startPos();
        while (pos.func_177956_o() > 0) {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            AxisAlignedBB bb = state.func_185900_c((IBlockAccess)this.field_70170_p, pos).func_186670_a(pos);
            if (this.ais.movementType != 2 || startPos.func_177956_o() > pos.func_177956_o() || state.func_185904_a() != Material.field_151586_h) {
                return bb.field_72337_e;
            }
            pos = pos.func_177977_b();
        }
        return 0.0;
    }

    private BlockPos calculateTopPos(BlockPos pos) {
        BlockPos check = pos;
        while (check.func_177956_o() > 0) {
            IBlockState state = this.field_70170_p.func_180495_p(check);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, check)) {
                return check;
            }
            check = check.func_177977_b();
        }
        return pos;
    }

    public boolean func_70686_a(@Nonnull Class<? extends EntityLivingBase> clazz) {
        return !this.ais.aiDisabled && EntityBat.class != clazz;
    }

    public boolean func_70067_L() {
        return !this.isKilled() && this.display.getHitboxState() != 1;
    }

    public boolean func_184652_a(@Nonnull EntityPlayer player) {
        return false;
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.display.getHitboxState() == 0;
    }

    public boolean func_70648_aU() {
        return this.ais.movementType == 2;
    }

    protected boolean func_70692_ba() {
        return this.stats.spawnCycle == 4;
    }

    public boolean canFly() {
        return false;
    }

    public boolean canSee(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            return Util.instance.npcCanSeeTarget((EntityLivingBase)this, (EntityLivingBase)entity, false, true);
        }
        return this.func_70635_at().func_75522_a(entity);
    }

    private void clearTasks(EntityAITasks tasks) {
        ArrayList list = new ArrayList(tasks.field_75782_a);
        for (EntityAITasks.EntityAITaskEntry entityaitaskentry : list) {
            try {
                tasks.func_85156_a(entityaitaskentry.field_75733_a);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        tasks.field_75782_a.clear();
    }

    public void cloakUpdate() {
        this.field_20066_r = this.field_20063_u;
        this.field_20065_s = this.field_20062_v;
        this.field_20064_t = this.field_20061_w;
        double d = this.field_70165_t - this.field_20063_u;
        double d2 = this.field_70163_u - this.field_20062_v;
        double d3 = this.field_70161_v - this.field_20061_w;
        double d4 = 10.0;
        if (d > d4) {
            double posX;
            this.field_20063_u = posX = this.field_70165_t;
            this.field_20066_r = posX;
        }
        if (d3 > d4) {
            double posZ;
            this.field_20061_w = posZ = this.field_70161_v;
            this.field_20064_t = posZ;
        }
        if (d2 > d4) {
            double posY;
            this.field_20062_v = posY = this.field_70163_u;
            this.field_20065_s = posY;
        }
        if (d < -d4) {
            double posX2;
            this.field_20063_u = posX2 = this.field_70165_t;
            this.field_20066_r = posX2;
        }
        if (d3 < -d4) {
            double posZ2;
            this.field_20061_w = posZ2 = this.field_70161_v;
            this.field_20064_t = posZ2;
        }
        if (d2 < -d4) {
            double posY2;
            this.field_20062_v = posY2 = this.field_70163_u;
            this.field_20065_s = posY2;
        }
        this.field_20063_u += d * 0.25;
        this.field_20061_w += d3 * 0.25;
        this.field_20062_v += d2 * 0.25;
    }

    protected void func_70665_d(@Nonnull DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        this.combatHandler.damage(damageSrc, damageAmount);
    }

    protected int func_70682_h(int par1) {
        if (!this.stats.canDrown) {
            return par1;
        }
        return super.func_70682_h(par1);
    }

    public void delete() {
        this.advanced.roleInterface.delete();
        this.advanced.jobInterface.delete();
        super.func_70106_y();
    }

    public void doorInteractType() {
        if (this.canFly()) {
            return;
        }
        Object aiDoor = null;
        if (this.ais.doorInteract == 1) {
            aiDoor = new EntityAIOpenDoor((EntityLiving)this, true);
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)aiDoor);
        } else if (this.ais.doorInteract == 0) {
            aiDoor = new EntityAIBustDoor((EntityLiving)this);
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)aiDoor);
        }
        if (this.func_70661_as() instanceof PathNavigateGround) {
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(aiDoor != null);
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RoleData, (Object)"");
        this.field_70180_af.func_187214_a(JobData, (Object)"");
        this.field_70180_af.func_187214_a(FactionData, (Object)0);
        this.field_70180_af.func_187214_a(Animation, (Object)0);
        this.field_70180_af.func_187214_a(Walking, (Object)false);
        this.field_70180_af.func_187214_a(Interacting, (Object)false);
        this.field_70180_af.func_187214_a(IsDead, (Object)false);
        this.field_70180_af.func_187214_a(Attacking, (Object)false);
        this.field_70180_af.func_187214_a(AimRotationYaw, (Object)Float.valueOf(361.0f));
    }

    public int followRange() {
        if (this.advanced.scenes.getOwner() != null) {
            return 4;
        }
        if (this.advanced.roleInterface.getEnumType() == RoleType.FOLLOWER && this.advanced.roleInterface.isFollowing()) {
            return 6;
        }
        if (this.advanced.roleInterface.getEnumType() == RoleType.COMPANION && this.advanced.roleInterface.isFollowing()) {
            return 4;
        }
        if (this.advanced.jobInterface.getEnumType() == JobType.FOLLOWER && this.advanced.jobInterface.isFollowing()) {
            return 4;
        }
        return Math.max(1, this.stats.aggroRange - 1);
    }

    public boolean func_94059_bO() {
        return true;
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            list.add(ItemStackWrapper.MCItem(this.inventory.armor.get(3 - i)));
        }
        return list;
    }

    public float func_180484_a(@Nonnull BlockPos pos) {
        if (this.ais.movementType == 2) {
            return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f : 0.0f;
        }
        float weight = this.field_70170_p.func_175724_o(pos) - 0.5f;
        if (this.field_70170_p.func_180495_p(pos).func_185914_p()) {
            weight += 10.0f;
        }
        return weight;
    }

    public boolean func_70601_bi() {
        return this.func_180484_a(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v)) >= 0.0f && this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_189884_a((Entity)this);
    }

    public Entity func_174793_f() {
        if (!this.func_70613_aW()) {
            return this;
        }
        EntityUtil.Copy((EntityLivingBase)this, (EntityLivingBase)CommandPlayer);
        CommandPlayer.func_70029_a(this.field_70170_p);
        CommandPlayer.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return CommandPlayer;
    }

    @Nonnull
    public EnumCreatureAttribute func_70668_bt() {
        return this.stats == null ? EnumCreatureAttribute.UNDEFINED : this.stats.creatureType;
    }

    public SoundEvent func_184615_bR() {
        return null;
    }

    private Dialog getDialog(EntityPlayer player) {
        HashSet<Integer> newDS = new HashSet<Integer>();
        Dialog dialog = null;
        for (int dialogId : this.dialogs) {
            if (!DialogController.instance.hasDialog(dialogId)) continue;
            newDS.add(dialogId);
            if (dialog != null) continue;
            Dialog d = DialogController.instance.get(dialogId);
            if (!d.availability.isAvailable(player)) continue;
            dialog = d;
        }
        if (newDS.size() != this.dialogs.length) {
            this.dialogs = new int[newDS.size()];
            int i = 0;
            Iterator iterator = newDS.iterator();
            while (iterator.hasNext()) {
                int id;
                this.dialogs[i] = id = ((Integer)iterator.next()).intValue();
                ++i;
            }
        }
        return dialog;
    }

    @Nonnull
    public World func_130014_f_() {
        return this.field_70170_p;
    }

    public Faction getFaction() {
        Faction fac = FactionController.instance.getFaction((Integer)this.field_70180_af.func_187225_a(FactionData));
        if (fac == null) {
            return FactionController.instance.getFaction(FactionController.instance.getFirstFactionId());
        }
        return fac;
    }

    public EntityPlayerMP getFakeChatPlayer() {
        if (!this.func_70613_aW()) {
            return null;
        }
        EntityUtil.Copy((EntityLivingBase)this, (EntityLivingBase)ChatEventPlayer);
        EntityNPCInterface.ChatEventProfile.npc = this;
        ChatEventPlayer.refreshDisplayName();
        ChatEventPlayer.func_70029_a(this.field_70170_p);
        ChatEventPlayer.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return ChatEventPlayer;
    }

    @Nonnull
    public Iterable<ItemStack> func_184214_aD() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(ItemStackWrapper.MCItem(this.inventory.weapons.get(0)));
        list.add(ItemStackWrapper.MCItem(this.inventory.weapons.get(2)));
        return list;
    }

    @Nonnull
    public ItemStack func_184614_ca() {
        IItemStack item = this.isAttacking() ? this.inventory.getRightHand() : (this.advanced.roleInterface instanceof RoleCompanion ? ((RoleCompanion)this.advanced.roleInterface).getHeldItem() : (this.advanced.jobInterface.overrideMainHand ? this.advanced.jobInterface.getMainhand() : this.inventory.getRightHand()));
        return ItemStackWrapper.MCItem(item);
    }

    @Nonnull
    public ItemStack func_184592_cb() {
        IItemStack item = this.isAttacking() ? this.inventory.getLeftHand() : (this.advanced.jobInterface.overrideOffHand ? this.advanced.jobInterface.getOffhand() : this.inventory.getLeftHand());
        return ItemStackWrapper.MCItem(item);
    }

    @Nonnull
    public ItemStack func_184582_a(@Nonnull EntityEquipmentSlot slot) {
        if (slot == EntityEquipmentSlot.MAINHAND) {
            return this.func_184614_ca();
        }
        if (slot == EntityEquipmentSlot.OFFHAND) {
            return this.func_184592_cb();
        }
        return ItemStackWrapper.MCItem(this.inventory.getArmor(3 - slot.func_188454_b()));
    }

    public String getJobData() {
        return (String)this.field_70180_af.func_187225_a(RoleData);
    }

    public boolean func_110167_bD() {
        return false;
    }

    public int func_70641_bl() {
        return 8;
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.display == null) {
            return "Display is null!";
        }
        return this.display.getName();
    }

    public EntityLivingBase getOwner() {
        if (this.ais.aiDisabled) {
            return null;
        }
        if (this.advanced.scenes.getOwner() != null) {
            return this.advanced.scenes.getOwner();
        }
        if (this.advanced.roleInterface instanceof RoleFollower) {
            return ((RoleFollower)this.advanced.roleInterface).owner;
        }
        if (this.advanced.roleInterface instanceof RoleCompanion) {
            return ((RoleCompanion)this.advanced.roleInterface).owner;
        }
        if (this.advanced.jobInterface instanceof JobFollower) {
            return ((JobFollower)this.advanced.jobInterface).following;
        }
        return null;
    }

    @Nonnull
    public BlockPos func_180425_c() {
        return new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Nonnull
    public Vec3d func_174791_d() {
        return new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Nonnull
    public EnumPushReaction func_184192_z() {
        return this.display.getHitboxState() == 0 ? super.func_184192_z() : EnumPushReaction.IGNORE;
    }

    public String getRoleData() {
        return (String)this.field_70180_af.func_187225_a(RoleData);
    }

    protected float func_70647_i() {
        if (this.advanced.disablePitch) {
            return 1.0f;
        }
        return super.func_70647_i();
    }

    public float getSpeed() {
        return (float)this.ais.getWalkingSpeed() / 20.0f;
    }

    public float getStartXPos() {
        return (float)this.ais.startPos().func_177958_n() + this.ais.bodyOffsetX / 10.0f;
    }

    public double getStartYPos() {
        if (this.startYPos < 0.0) {
            return this.calculateStartYPos(this.ais.startPos());
        }
        return this.startYPos;
    }

    public float getStartZPos() {
        return (float)this.ais.startPos().func_177952_p() + this.ais.bodyOffsetZ / 10.0f;
    }

    public int func_70627_aG() {
        return 160;
    }

    public void givePlayerItem(EntityPlayer player, ItemStack item) {
        if (this.ais.aiDisabled || !this.func_70613_aW()) {
            return;
        }
        item = item.func_77946_l();
        float f = 0.7f;
        double d = this.field_70170_p.field_73012_v.nextFloat() * f + (1.0f - f);
        double d2 = this.field_70170_p.field_73012_v.nextFloat() * f + (1.0f - f);
        double d3 = this.field_70170_p.field_73012_v.nextFloat() * f + (1.0f - f);
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + d, this.field_70163_u + d2, this.field_70161_v + d3, item);
        entityitem.func_174867_a(2);
        this.field_70170_p.func_72838_d((Entity)entityitem);
        int i = item.func_190916_E();
        if (player.field_71071_by.func_70441_a(item)) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_71001_a((Entity)entityitem, i);
            if (item.func_190916_E() <= 0) {
                entityitem.func_70106_y();
            }
        }
    }

    public boolean hasOwner() {
        if (this.ais.aiDisabled) {
            return false;
        }
        return this.getOwner() != null;
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(Attacking);
    }

    public boolean func_70089_S() {
        boolean bo = super.func_70089_S();
        if (!bo || this.ais != null && this.ais.aiDisabled) {
            return bo;
        }
        return !this.isKilled();
    }

    public boolean isFollower() {
        if (this.ais.aiDisabled) {
            return false;
        }
        return this.advanced.scenes.getOwner() != null || this.advanced.roleInterface.isFollowing() || this.advanced.jobInterface.isFollowing();
    }

    public boolean isFriend(Entity entityTarget) {
        if (!(entityTarget instanceof EntityNPCInterface)) {
            return false;
        }
        EntityNPCInterface npcTarget = (EntityNPCInterface)entityTarget;
        return this.faction.id == npcTarget.faction.id || npcTarget.faction.frendFactions.contains(this.faction.id) || npcTarget.advanced.friendFactions.contains(this.faction.id) || this.faction.frendFactions.contains(npcTarget.faction.id) || this.advanced.friendFactions.contains(npcTarget.faction.id);
    }

    public boolean isInRange(double posX, double posY, double posZ, double range) {
        double y = Math.abs(this.field_70163_u - posY);
        if (posY >= 0.0 && y > range) {
            return false;
        }
        double x = Math.abs(this.field_70165_t - posX);
        double z = Math.abs(this.field_70161_v - posZ);
        return x <= range && z <= range;
    }

    public boolean isInRange(Entity entity, double range) {
        return this.isInRange(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range);
    }

    public boolean isInteracting() {
        return this.field_70173_aa - this.lastInteract < 40 || !this.func_70613_aW() && (Boolean)this.field_70180_af.func_187225_a(Interacting) != false || this.ais.stopAndInteract && !this.interactingEntities.isEmpty() && this.field_70173_aa - this.lastInteract < 180;
    }

    public boolean func_82150_aj() {
        return this.display.getVisible() == 1;
    }

    public boolean func_98034_c(@Nonnull EntityPlayer player) {
        return this.func_82150_aj() && !(player.func_184614_ca().func_77973_b() instanceof INPCToolItem) && this.display.getAvailability().isAvailable(player);
    }

    public boolean isKilled() {
        return this.field_70128_L || this.field_70180_af != null && (Boolean)this.field_70180_af.func_187225_a(IsDead) != false;
    }

    public boolean isMoving() {
        double xz;
        double sp = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        double speed = 0.069;
        if (sp != 0.0) {
            speed = speed * 0.25 / sp;
        }
        return (xz = Math.sqrt(Math.pow(this.field_70159_w, 2.0) + Math.pow(this.field_70179_y, 2.0))) >= speed / 2.0 && (this.field_70181_x <= -speed || this.field_70181_x > 0.0);
    }

    public boolean func_184191_r(@Nonnull Entity entity) {
        if (this.func_70613_aW()) {
            if (entity instanceof EntityPlayer && this.getFaction().isFriendlyToPlayer((EntityPlayer)entity)) {
                return true;
            }
            if (entity == this.getOwner()) {
                return true;
            }
            if (entity instanceof EntityNPCInterface && ((EntityNPCInterface)entity).faction.id == this.faction.id) {
                return true;
            }
        }
        return super.func_184191_r(entity);
    }

    public boolean func_70608_bn() {
        return this.func_110143_aJ() <= 0.0f || this.currentAnimation == 2 && !this.isAttacking() && this.func_94060_bK() == null && this.navigating == null;
    }

    public boolean func_70687_e(@Nonnull PotionEffect effect) {
        return !this.stats.potionImmune && (this.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD || effect.func_188419_a() != MobEffects.field_76436_u) && super.func_70687_e(effect);
    }

    public boolean func_96092_aw() {
        return this.ais.movementType != 2;
    }

    public boolean func_70093_af() {
        return this.currentAnimation == 4 || this.aiIsSneak;
    }

    public boolean isVeryNearAssignedPlace() {
        double xx = this.field_70165_t - (double)this.getStartXPos();
        double zz = this.field_70161_v - (double)this.getStartZPos();
        return xx >= -0.2 && xx <= 0.2 && zz >= -0.2 && zz <= 0.2;
    }

    public boolean isWalking() {
        return this.ais.getMovingType() != 0 || this.isAttacking() || this.isFollower() || (Boolean)this.field_70180_af.func_187225_a(Walking) != false;
    }

    public void func_70653_a(@Nonnull Entity entity, float strength, double ratioX, double ratioZ) {
        super.func_70653_a(entity, strength * (2.0f - this.stats.resistances.get("knockback")), ratioX, ratioZ);
    }

    public boolean nearPosition(BlockPos pos) {
        BlockPos npcPos = this.func_180425_c();
        float x = npcPos.func_177958_n() - pos.func_177958_n();
        float z = npcPos.func_177952_p() - pos.func_177952_p();
        float y = npcPos.func_177956_o() - pos.func_177956_o();
        float height = MathHelper.func_76123_f((float)(this.field_70131_O + 1.0f)) * MathHelper.func_76123_f((float)(this.field_70131_O + 1.0f));
        return (double)(x * x + z * z) < 2.5 && (double)(y * y) < (double)height + 2.5;
    }

    public void onAttack(EntityLivingBase entity) {
        if (this.ais.aiDisabled || entity == null || entity == this || this.isAttacking() || this.ais.onAttack == 3 || entity == this.getOwner()) {
            return;
        }
        super.func_70624_b(entity);
    }

    protected void func_82167_n(@Nonnull Entity entityIn) {
        if (this.func_70067_L() && this.display.getHitboxState() != 1 && this.ais.canBeCollide && !this.hitboxRiding.containsKey(entityIn)) {
            entityIn.func_70108_f((Entity)this);
        }
    }

    public void func_70108_f(@Nonnull Entity entityIn) {
        if (!this.func_70067_L() || !this.ais.canBeCollide || this.hitboxRiding.containsKey(entityIn)) {
            return;
        }
        super.func_70108_f(entityIn);
    }

    public void onCollide() {
        if (this.ais.aiDisabled || !this.func_70089_S() || this.field_70173_aa % 4 != 0 || !this.func_70613_aW()) {
            return;
        }
        AxisAlignedBB axisalignedbb = this.func_184187_bx() != null && this.func_184187_bx().func_70089_S() ? this.func_174813_aQ().func_111270_a(this.func_184187_bx().func_174813_aQ()).func_72314_b(1.0, 0.0, 1.0) : this.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0);
        List list = new ArrayList();
        try {
            list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Entity entity : list) {
            if (entity == this || !entity.func_70089_S()) continue;
            EventHooks.onNPCCollide(this, entity);
        }
    }

    public void func_70645_a(@Nonnull DamageSource damagesource) {
        AnimationConfig anim;
        this.func_70031_b(false);
        this.func_70661_as().func_75499_g();
        this.func_70066_B();
        this.func_70674_bp();
        Entity attackingEntity = NoppesUtilServer.GetDamageSource(damagesource);
        if (this.advanced.roleInterface != null) {
            this.advanced.roleInterface.aiDeathExecute(attackingEntity);
        }
        if (this.advanced.jobInterface != null) {
            this.advanced.jobInterface.aiDeathExecute(attackingEntity);
        }
        if (this.func_70613_aW()) {
            Map<IEntity<?>, List<IItemStack>> mapD;
            this.advanced.playSound(3, this.func_70599_aP(), this.func_70647_i());
            NpcEvent.DiedEvent event = new NpcEvent.DiedEvent(this.wrappedNPC, damagesource, attackingEntity, this.combatHandler);
            double baseChance = 1.0;
            if (!this.combatHandler.aggressors.isEmpty()) {
                double luck = 0.0;
                double enchLv = 0.0;
                int i = 0;
                int j = 0;
                for (EntityLivingBase e : this.combatHandler.aggressors.keySet()) {
                    ItemStack held;
                    IAttributeInstance l = e.func_110148_a(SharedMonsterAttributes.field_188792_h);
                    if (l != null) {
                        luck += l.func_111126_e();
                        ++i;
                    }
                    if (!(held = !e.func_184614_ca().func_190926_b() ? e.func_184614_ca() : e.func_184592_cb()).func_77948_v()) continue;
                    enchLv += (double)EnchantmentHelper.func_185283_h((EntityLivingBase)e);
                    ++j;
                }
                if (i > 0 && luck > 0.0) {
                    baseChance = (luck /= (double)i) < 0.0 ? (baseChance -= (luck *= -1.0) * luck * -0.005555 + luck * 0.255555) : (baseChance += luck * luck * -0.005555 + luck * 0.255555);
                }
                if (j > 0 && enchLv > 0.0) {
                    baseChance += (enchLv /= (double)j) * enchLv * 5.55E-4 + enchLv * 0.019444;
                }
            }
            if ((mapD = this.inventory.createDrops(0, baseChance)).isEmpty()) {
                event.droppedItems = new IItemStack[0];
            } else {
                ArrayList list = new ArrayList();
                event.droppedItems = new IItemStack[mapD.size()];
                for (IEntity<?> attacking : mapD.keySet()) {
                    list.addAll(mapD.get(attacking));
                }
                event.droppedItems = list.toArray(new IItemStack[0]);
            }
            event.lootedItems = this.inventory.createDrops(1, baseChance);
            event.inventoryItems = this.inventory.createDrops(2, baseChance);
            event.expDropped = this.inventory.getExpRNG();
            event.line = this.advanced.getKilledLine();
            if (this.advanced.roleInterface instanceof RoleFollower && !((RoleFollower)this.advanced.roleInterface).inventory.func_191420_l()) {
                for (ItemStack stack : ((RoleFollower)this.advanced.roleInterface).inventory.items) {
                    if (NoppesUtilServer.IsItemStackNull(stack) || stack.func_190926_b()) continue;
                    this.func_70099_a(stack, 0.0f);
                }
                ((RoleFollower)this.advanced.roleInterface).inventory.func_174888_l();
            }
            EventHooks.onNPCDied(this, event);
            this.bossInfo.func_186758_d(false);
            this.inventory.dropStuff(event, damagesource);
            if (event.line != null) {
                this.saySurrounding(Line.formatTarget((Line)event.line, attackingEntity instanceof EntityLivingBase ? (EntityLivingBase)attackingEntity : null));
            }
        }
        if ((anim = this.animation.tryRunAnimation(AnimationKind.DIES)) != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        super.func_70645_a(damagesource);
    }

    public void func_70609_aI() {
        if (this.stats.spawnCycle == 3 || this.stats.spawnCycle == 4) {
            super.func_70609_aI();
            return;
        }
        ++this.field_70725_aQ;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.hasDied) {
            this.func_70106_y();
        }
        if (this.killedTime < System.currentTimeMillis() && (this.stats.spawnCycle == 0 || this.field_70170_p.func_72935_r() && this.stats.spawnCycle == 1 || !this.field_70170_p.func_72935_r() && this.stats.spawnCycle == 2)) {
            this.reset();
        }
    }

    public void func_70636_d() {
        float f;
        if (CustomNpcs.FreezeNPCs) {
            return;
        }
        if (!this.hitboxRiding.isEmpty()) {
            if (this.display.getHitboxState() != 2 || this.isKilled()) {
                this.hitboxRiding.clear();
            } else {
                for (Map.Entry<Entity, double[]> entry : new ArrayList<Map.Entry<Entity, double[]>>(this.hitboxRiding.entrySet())) {
                    boolean isSetPos;
                    Entity entity = entry.getKey();
                    if (entity instanceof EntityPlayer && this.func_70613_aW()) continue;
                    boolean bl = isSetPos = !this.func_184196_w(entity) && entity.field_70181_x <= 0.0;
                    if (isSetPos) {
                        AxisAlignedBB npcBB = this.func_174813_aQ();
                        AxisAlignedBB entityBB = entity.func_174813_aQ();
                        if (!this.func_70661_as().func_75500_f()) {
                            npcBB = npcBB.func_72314_b((double)this.field_70130_N * 0.25, 0.0, (double)this.field_70130_N * 0.25);
                        }
                        boolean bl2 = isSetPos = npcBB.field_72340_a < entityBB.field_72336_d && npcBB.field_72336_d > entityBB.field_72340_a && npcBB.field_72339_c < entityBB.field_72334_f && npcBB.field_72334_f > entityBB.field_72339_c;
                    }
                    if (isSetPos) {
                        double[] addPos = entry.getValue();
                        if (this.field_70181_x <= 0.0) {
                            addPos[0] = addPos[0] - entity.field_70159_w * 1.5;
                            addPos[1] = addPos[1] - entity.field_70179_y * 1.5;
                            if (this.field_70159_w != 0.0 || this.field_70179_y != 0.0) {
                                entity.field_70159_w *= 0.75;
                                entity.field_70179_y *= 0.75;
                            }
                        }
                        double x = this.field_70165_t - addPos[0];
                        double y = this.field_70163_u + (double)this.field_70131_O * 1.025;
                        double z = this.field_70161_v - addPos[1];
                        entity.field_70122_E = true;
                        entity.func_70107_b(x, y, z);
                        entity.field_70133_I = true;
                        if (!(entity instanceof EntityPlayer)) continue;
                        CustomNpcs.proxy.updatePlayerPos();
                        continue;
                    }
                    entity.field_70159_w += this.field_70159_w * 1.1;
                    entity.field_70181_x += this.field_70181_x;
                    entity.field_70179_y += this.field_70179_y * 1.1;
                    this.hitboxRiding.remove(entity);
                }
            }
        }
        if (this.func_175446_cd()) {
            super.func_70636_d();
            return;
        }
        ++this.totalTicksAlive;
        this.func_82168_bl();
        if (this.totalTicksAlive % 20L == 0L) {
            this.faction = this.getFaction();
        }
        if (this.func_70613_aW()) {
            if (!this.ais.aiDisabled) {
                if (this.aiAttackTarget != null) {
                    this.aiAttackTarget.update();
                }
                if (!this.isKilled() && this.totalTicksAlive % 20L == 0L) {
                    this.advanced.scenes.update();
                    if (this.func_110143_aJ() < this.func_110138_aP()) {
                        if (this.stats.healthRegen > 0 && !this.isAttacking()) {
                            this.func_70691_i(this.stats.healthRegen);
                            if (CustomNpcs.ShowHealingParticles) {
                                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, 1, (double)this.field_70130_N / 3.0, 0.05, (double)this.field_70130_N / 3.0, 1.0, new int[0]);
                            }
                        }
                        if (this.stats.combatRegen > 0 && this.isAttacking()) {
                            this.func_70691_i(this.stats.combatRegen);
                            if (CustomNpcs.ShowHealingParticles) {
                                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, 1, (double)this.field_70130_N / 3.0, 0.05, (double)this.field_70130_N / 3.0, 1.0, new int[0]);
                            }
                        }
                    }
                    if (this.faction.getsAttacked) {
                        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111265_b);
                        for (EntityMob mob : Util.instance.getEntitiesWithinDist(EntityMob.class, this.field_70170_p, (Entity)this, iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e())) {
                            if (mob.func_70638_az() != null || !mob.func_70685_l((Entity)this)) continue;
                            mob.func_70624_b((EntityLivingBase)this);
                        }
                    }
                    if (this.linkedData != null && this.linkedData.time > this.linkedLast) {
                        LinkedNpcController.Instance.loadNpcData(this);
                    }
                    if (this.updateClient) {
                        this.updateClient();
                    }
                    if (this.updateAI) {
                        this.updateTasks();
                        this.updateAI = false;
                    }
                }
            }
            if (this.updateLook) {
                Server.sendToAll(this.field_70170_p.func_73046_m(), EnumPacketClient.NPC_LOOK_POS, this.field_70170_p.field_73011_w.getDimension(), this.func_145782_y(), this.lookAt == null ? -1 : this.lookAt.func_145782_y());
            }
            if (this.func_110143_aJ() <= 0.0f && !this.isKilled()) {
                this.func_70674_bp();
                this.field_70180_af.func_187227_b(IsDead, (Object)true);
                this.updateTasks();
                this.updateHitbox();
            }
            if (this.display.getBossbar() == 2) {
                this.bossInfo.func_186758_d(this.func_70638_az() != null);
            }
            this.field_70180_af.func_187227_b(Walking, (Object)(!this.func_70661_as().func_75500_f() ? 1 : 0));
            this.field_70180_af.func_187227_b(Interacting, (Object)this.isInteracting());
            this.combatHandler.update();
            this.onCollide();
        } else {
            DataParameter<Byte> hand_states = ((IEntityLivingBaseMixin)((Object)this)).npcs$getHandStates();
            ItemStack stack = this.func_184614_ca();
            if (stack.func_77973_b() instanceof ItemBow && hand_states != null) {
                if (this.currentAnimation == 6 && (Byte)this.func_184212_Q().func_187225_a(hand_states) != 1) {
                    if ((Byte)this.func_184212_Q().func_187225_a(hand_states) != 1) {
                        this.func_184212_Q().func_187227_b(hand_states, (Object)1);
                        this.func_184598_c(EnumHand.MAIN_HAND);
                    }
                } else if (this.currentAnimation != 6 && (Byte)this.func_184212_Q().func_187225_a(hand_states) == 1) {
                    this.func_184597_cx();
                    this.func_184212_Q().func_187227_b(hand_states, (Object)0);
                }
                stack.func_77973_b().func_77663_a(stack, this.field_70170_p, (Entity)this, 0, true);
            }
            boolean bl = this.field_70160_al = this.canFly() && this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_185904_a() == Material.field_151579_a;
            if (this.func_70638_az() != null) {
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 3.0f, 1.5f);
                this.func_70671_ap().func_75649_a();
            }
        }
        if (CustomNpcs.ShowCustomAnimation) {
            CustomNPCsScheduler.runTack(() -> {
                if (!(this.animation.getJump() || this.isKilled() || !(this.func_110143_aJ() > 0.0f) || this.field_70170_p == null || this.func_70090_H() || this.func_180799_ab() || this.ais.getNavigationType() != 0 || this.field_70122_E || !(this.field_70181_x > 0.0))) {
                    boolean canLandThere;
                    BlockPos posUnderfoot = this.func_180425_c().func_177977_b();
                    BlockPos posAhead = this.func_180425_c().func_177963_a(this.field_70159_w, 0.0, this.field_70179_y).func_177977_b();
                    boolean canJumpHere = !(this.field_70170_p.func_180495_p(posUnderfoot).func_177230_c() instanceof BlockStairs);
                    boolean bl = canLandThere = !(this.field_70170_p.func_180495_p(posAhead).func_177230_c() instanceof BlockStairs);
                    if (canJumpHere && canLandThere) {
                        this.animation.setJump(true);
                        this.animation.tryRunAnimation(AnimationKind.JUMP);
                    }
                } else if (this.animation.getJump() && this.field_70122_E && this.animation.getAnimationStage() != EnumAnimationStages.Started) {
                    this.animation.setJump(false);
                    if (this.animation.isAnimated(AnimationKind.JUMP)) {
                        this.animation.stopAnimation();
                    }
                }
                if (!this.animation.getSwing() && this.field_70733_aJ > 0.0f) {
                    AnimationConfig anim;
                    this.animation.setSwing(true);
                    if (!this.animation.isAnimated(AnimationKind.ATTACKING, AnimationKind.AIM, AnimationKind.SHOOT) && (anim = this.animation.tryRunAnimation(AnimationKind.SWING)) != null) {
                        this.field_70733_aJ = 0.0f;
                        this.field_110158_av = 0;
                        this.field_70732_aI = 0.0f;
                        this.field_82175_bq = false;
                    }
                } else if (this.animation.getSwing() && this.field_70733_aJ == 0.0f) {
                    this.animation.setSwing(false);
                }
                this.animation.resetWalkAndStandAnimations();
            });
        }
        if (this.wasKilled != this.isKilled() && this.wasKilled) {
            this.reset();
        }
        if (this.field_70170_p.func_72935_r() && this.func_70613_aW() && this.stats.burnInSun && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175710_j(new BlockPos((Entity)this))) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
        if (this.field_70180_af != null && this.isAttacking() && this.func_70638_az() != null) {
            this.field_70180_af.func_187227_b(AimRotationYaw, (Object)Float.valueOf(this.field_70759_as));
        }
        if (!this.func_70613_aW()) {
            this.advanced.roleInterface.clientUpdate();
            if (this.textureCloakLocation != null) {
                this.cloakUpdate();
            }
            if (this.currentAnimation != (Integer)this.field_70180_af.func_187225_a(Animation)) {
                this.currentAnimation = (Integer)this.field_70180_af.func_187225_a(Animation);
                this.animationStart = this.field_70173_aa;
                this.updateHitbox();
            }
            if (!this.ais.aiDisabled && this.advanced.jobInterface instanceof JobBard) {
                ((JobBard)this.advanced.jobInterface).onLivingUpdate();
            }
        }
        if (this.display.getBossbar() > 0) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public void func_70071_h_() {
        CustomNpcs.debugData.start((Object)this);
        super.func_70071_h_();
        if (this.animation != null) {
            this.animation.updateTime();
        }
        if (!this.ais.aiDisabled && this.field_70173_aa % 10 == 0) {
            Vec3d vec;
            if (this.initTime != 0L && !this.func_70613_aW() && this.initTime < System.currentTimeMillis() - 1000L) {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.NpcData, this.func_145782_y());
                this.initTime = 0L;
            }
            if (!this.isKilled() && this.field_70130_N <= 1.0E-5f) {
                this.updateHitbox();
            }
            Path path = this.func_70661_as().func_75505_d();
            if (this.func_70613_aW()) {
                if (path != null) {
                    PathPoint fp = path.func_75870_c();
                    BlockPos pos = this.func_180425_c();
                    if (fp == null || pos.func_177958_n() == fp.field_75839_a && pos.func_177956_o() == fp.field_75837_b && pos.func_177952_p() == fp.field_75838_c) {
                        this.navigating = null;
                        this.updateNavClient();
                    } else if (path != this.navigating) {
                        this.navigating = path;
                        this.updateNavClient();
                    }
                } else if (this.navigating != null) {
                    this.navigating = null;
                    this.updateNavClient();
                }
            }
            if (!(this.ais.onAttack != 1 || !this.func_70027_ad() && this.func_70638_az() == null || !this.func_70661_as().func_75500_f() && this.isMoving() || (vec = RandomPositionGenerator.func_75463_a((EntityCreature)this, (int)5, (int)4)) == null || CustomNpcs.ShowCustomAnimation && this.animation.isAnimated(AnimationKind.ATTACKING, AnimationKind.INIT, AnimationKind.INTERACT, AnimationKind.DIES))) {
                this.func_70661_as().func_75492_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.3);
            }
            this.startYPos = this.calculateStartYPos(this.ais.startPos()) + 1.0;
            if ((this.startYPos < 0.0 || this.startYPos > 255.0) && this.func_70613_aW()) {
                this.func_70106_y();
            }
            EventHooks.onNPCTick(this);
        }
        if (this.func_70093_af() && !this.isOldSneaking || !this.func_70093_af() && this.isOldSneaking) {
            this.updateHitbox();
            this.isOldSneaking = this.func_70093_af();
        }
        if (this.field_70725_aQ > 0 || this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75102_a) {
            super.func_70624_b(null);
        }
        if (!this.ais.aiDisabled) {
            this.timers.update();
        }
        if (!this.func_70613_aW()) {
            if (this.wasKilled != this.isKilled()) {
                this.field_70725_aQ = 0;
                this.updateHitbox();
            } else if (!this.isAttacking() && this.func_70661_as().func_75500_f() && this.currentAnimation != this.ais.animationType) {
                this.currentAnimation = this.ais.animationType;
                this.updateHitbox();
            }
        }
        this.wasKilled = this.isKilled();
        if (this.currentAnimation == 14) {
            this.field_70725_aQ = 19;
        }
        CustomNpcs.debugData.end((Object)this);
    }

    protected void playHurtSound(DamageSource ignoredSource, boolean isBlocked) {
        this.advanced.playSound(isBlocked ? 5 : 2, this.func_70599_aP(), this.func_70647_i());
    }

    public void func_70642_aH() {
        if (!this.func_70089_S()) {
            return;
        }
        this.advanced.playSound(this.func_70638_az() != null ? 1 : 0, this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_180429_a(@Nonnull BlockPos pos, @Nonnull Block block) {
        if (this.advanced.getSound(4) != null) {
            this.advanced.playSound(4, 0.15f, 1.0f);
        } else {
            super.func_180429_a(pos, block);
        }
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        QuestData data;
        AnimationConfig anim;
        if (!this.func_70613_aW()) {
            return !this.isAttacking();
        }
        if (hand != EnumHand.MAIN_HAND) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item == CustomRegisters.moving) {
            this.func_70624_b(null);
            if (player.func_184614_ca().func_77978_p() == null || this.func_145782_y() != player.func_184614_ca().func_77978_p().func_74762_e("NPCID")) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.pather.reg", new Object[]{this.func_70005_c_(), stack.func_82833_r()}));
            }
            stack.func_77983_a("NPCID", (NBTBase)new NBTTagInt(this.func_145782_y()));
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.NPC_MOVING_PATH, this.func_145782_y(), this.ais.writeToNBT(new NBTTagCompound()));
            return true;
        }
        if (item instanceof INPCToolItem) {
            this.func_70624_b(null);
            this.func_70604_c(null);
            return true;
        }
        if (!this.ais.aiDisabled && EventHooks.onNPCInteract(this, player)) {
            return false;
        }
        if (this.getFaction().isAggressiveToPlayer(player)) {
            if (!this.isAttacking()) {
                this.func_70624_b((EntityLivingBase)player);
            }
            return !this.isAttacking();
        }
        this.addInteract((EntityLivingBase)player);
        if (!(this.lookAi != null && this.lookAi.fastRotation || (anim = this.animation.tryRunAnimation(AnimationKind.INTERACT)) == null)) {
            this.lookAi.fastRotation = true;
            CustomNPCsScheduler.runTack(() -> {
                this.lookAi.fastRotation = false;
            }, anim.totalTicks * 50);
        }
        Dialog dialog = this.getDialog(player);
        PlayerData pd = PlayerData.get(player);
        if (!this.faction.getIsHidden() && !pd.factionData.factionData.containsKey(this.faction.id)) {
            PlayerEvent.FactionUpdateEvent event = new PlayerEvent.FactionUpdateEvent((PlayerWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), this.faction, this.faction.defaultPoints, true);
            EventHooks.onPlayerFactionChange(pd.scriptData, event);
            pd.factionData.factionData.put(this.faction.id, event.points);
        }
        if ((data = pd.questData.getQuestCompletion(player, this)) != null) {
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.QUEST_COMPLETION, data.quest.id);
        } else if (dialog != null) {
            NoppesUtilServer.openDialog(player, this, dialog);
        } else if (!this.ais.aiDisabled && this.advanced.roleInterface.getType() > 0) {
            this.advanced.roleInterface.interact(player);
        } else {
            this.say(player, this.advanced.getInteractLine());
        }
        return true;
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.npcVersion = compound.func_74762_e("ModRev");
        VersionCompatibility.CheckNpcCompatibility(this, compound);
        this.display.readToNBT(compound);
        this.stats.readToNBT(compound);
        this.ais.readToNBT(compound);
        this.script.readFromNBT(compound);
        this.timers.readFromNBT(compound);
        this.advanced.load(compound);
        this.animation.load(compound);
        this.inventory.readEntityFromNBT(compound);
        this.transform.load(compound);
        this.killedTime = compound.func_74763_f("KilledTime");
        this.totalTicksAlive = compound.func_74763_f("TotalTicksAlive");
        this.linkedName = compound.func_74779_i("LinkedNpcName");
        if (this.func_70613_aW()) {
            LinkedNpcController.Instance.loadNpcData(this);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)CustomNpcs.NpcNavRange);
        this.updateAI = true;
        if (compound.func_150297_b("HomeDimensionId", 3)) {
            this.homeDimensionId = compound.func_74762_e("HomeDimensionId");
        }
    }

    public void readSpawnData(ByteBuf buf) {
        try {
            this.readSpawnData(Server.readNBT(buf));
        }
        catch (IOException e) {
            LogWriter.error(e);
        }
    }

    public void readSpawnData(NBTTagCompound compound) {
        this.display.readToNBT(compound);
        this.animation.load(compound);
        this.stats.setLevel(compound.func_74762_e("NPCLevel"));
        this.stats.setRarity(compound.func_74762_e("NPCRarity"));
        this.stats.setRarityTitle(compound.func_74779_i("NPCRarityTitle"));
        this.stats.setMaxHealth(compound.func_74762_e("MaxHealth"));
        this.stats.hideKilledBody = compound.func_74767_n("DeadBody");
        this.stats.aggroRange = compound.func_74762_e("AggroRange");
        if (this.stats.aggroRange < 1) {
            this.stats.aggroRange = 1;
        }
        IAttributeInstance follow_range = this.func_110148_a(SharedMonsterAttributes.field_111265_b);
        follow_range.func_111128_a((double)this.stats.aggroRange);
        this.ais.setWalkingSpeed(compound.func_74762_e("Speed"));
        this.ais.setStandingType(compound.func_74762_e("StandingState"));
        this.ais.setMovingType(compound.func_74762_e("MovingState"));
        this.ais.orientation = compound.func_74762_e("Orientation");
        this.ais.bodyOffsetX = compound.func_74760_g("PositionXOffset");
        this.ais.bodyOffsetY = compound.func_74760_g("PositionYOffset");
        this.ais.bodyOffsetZ = compound.func_74760_g("PositionZOffset");
        if (compound.func_150297_b("MaxHurtResistantTime", 3)) {
            this.ais.setMaxHurtResistantTime(compound.func_74762_e("MaxHurtResistantTime"));
            this.field_70771_an = this.ais.getMaxHurtResistantTime();
        }
        this.inventory.armor = NBTTags.getIItemStackMap(compound.func_150295_c("Armor", 10));
        this.inventory.weapons = NBTTags.getIItemStackMap(compound.func_150295_c("Weapons", 10));
        if (this.advanced.jobInterface instanceof JobBard) {
            NBTTagCompound bard = compound.func_74775_l("Bard");
            this.advanced.jobInterface.load(bard);
        }
        if (this.advanced.jobInterface instanceof JobFollower) {
            NBTTagCompound follower = compound.func_74775_l("Companion");
            this.advanced.jobInterface.load(follower);
        }
        if (this instanceof EntityCustomNpc) {
            ((EntityCustomNpc)this).modelData.load(compound.func_74775_l("ModelData"));
        }
        this.advanced.load(compound);
        this.field_70180_af.func_187227_b(IsDead, (Object)compound.func_74767_n("IsDead"));
        this.field_70725_aQ = compound.func_74762_e("DeathTime");
        NBTTagList lookPosList = compound.func_150295_c("LookPos", 5);
        this.lookPos[0] = ValueUtil.correctFloat(lookPosList.func_150308_e(0), -45.0f, 45.0f);
        this.lookPos[1] = ValueUtil.correctFloat(lookPosList.func_150308_e(1), -45.0f, 45.0f);
        this.baseWidth = compound.func_74760_g("BaseWidth");
        this.baseHeight = compound.func_74760_g("BaseHeight");
        this.field_70130_N = compound.func_74760_g("Width");
        this.field_70131_O = compound.func_74760_g("Height");
    }

    public void func_184203_c(@Nonnull EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void reset() {
        EntityLivingBase entity;
        this.baseWidth = 0.6f;
        this.baseHeight = 1.9f;
        this.baseEyeHeight = 1.615f;
        this.eyeHeight = 1.615f;
        if (this instanceof EntityCustomNpc && (entity = ((EntityCustomNpc)this).modelData.getEntity(this)) != null) {
            this.baseWidth = entity.field_70130_N;
            this.baseHeight = entity.field_70131_O;
            this.baseEyeHeight = entity.func_70047_e();
            this.eyeHeight = entity.func_70047_e();
        }
        if (!this.func_70613_aW()) {
            try {
                Class<?> tgDTC = Class.forName("techguns.capabilities.TGDeathTypeCap");
                Method get = tgDTC.getMethod("get", EntityLivingBase.class);
                Object cap = get.invoke(null, new Object[]{this});
                Method getDeathType = tgDTC.getMethod("getDeathType", new Class[0]);
                Object dt = getDeathType.invoke(cap, new Object[0]);
                if (!dt.toString().equals("DEFAULT")) {
                    Class<?> edt = Class.forName("techguns.deatheffects.EntityDeathUtils$DeathType");
                    Method setDeathType = tgDTC.getMethod("setDeathType", edt);
                    setDeathType.invoke(cap, edt.getEnumConstants()[0]);
                }
            }
            catch (Exception tgDTC) {
                // empty catch block
            }
        }
        this.hasDied = false;
        this.field_70128_L = false;
        this.wasKilled = false;
        this.func_70031_b(false);
        this.aiIsSneak = false;
        this.aiOwnerNPC = null;
        this.updateAiClient();
        this.func_70606_j(this.func_110138_aP());
        this.field_70180_af.func_187227_b(Animation, (Object)0);
        this.field_70180_af.func_187227_b(Walking, (Object)false);
        this.field_70180_af.func_187227_b(IsDead, (Object)false);
        this.field_70180_af.func_187227_b(Interacting, (Object)false);
        this.interactingEntities.clear();
        this.combatHandler.reset();
        this.func_70624_b(null);
        this.func_70604_c(null);
        this.field_70725_aQ = 0;
        this.func_70015_d(0);
        this.lookAt = null;
        if (this.lookAi != null) {
            this.lookAi.fastRotation = false;
        }
        this.updateLook = false;
        if (this.ais.returnToStart && (this.advanced.jobInterface instanceof JobFollower || !this.hasOwner()) && this.func_70613_aW() && !this.func_184218_aH()) {
            BlockPos pos;
            IBlockState state;
            double x = this.getStartXPos();
            double y = this.getStartYPos();
            double z = this.getStartZPos();
            if (this.field_70170_p != null && (state = this.field_70170_p.func_180495_p(pos = new BlockPos(x, y, z))).func_177230_c().func_176205_b((IBlockAccess)this.field_70170_p, pos)) {
                for (int i = (int)y; i >= 0; --i) {
                    state = this.field_70170_p.func_180495_p(pos = pos.func_177977_b());
                    if (state.func_177230_c().func_176205_b((IBlockAccess)this.field_70170_p, pos)) continue;
                    if (!(y - (double)(pos = pos.func_177984_a()).func_177956_o() < 3.0)) break;
                    y = pos.func_177956_o();
                    break;
                }
            }
            this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        }
        this.field_70771_an = this.ais.getMaxHurtResistantTime();
        this.killedTime = 0L;
        this.func_70066_B();
        this.func_70674_bp();
        this.func_191986_a(0.0f, 0.0f, 0.0f);
        this.field_70140_Q = 0.0f;
        this.func_70661_as().func_75499_g();
        this.currentAnimation = 0;
        this.updateHitbox();
        this.updateAI = true;
        this.ais.movingPos = 0;
        if (this.getOwner() != null) {
            this.getOwner().func_130011_c(Objects.requireNonNull(EntityList.func_191304_a(EntityPainting.class, (World)this.field_70170_p)));
        }
        this.bossInfo.func_186758_d(this.display.getBossbar() == 1);
        this.advanced.jobInterface.reset();
        this.animation.stopAnimation();
        this.animation.tryRunAnimation(AnimationKind.INIT);
        this.updateClient = true;
        if (this.ais.returnToStart && this.homeDimensionId != this.field_70170_p.field_73011_w.getDimension() && (this.advanced.roleInterface.getEnumType() != RoleType.FOLLOWER || !this.advanced.roleInterface.isFollowing())) {
            try {
                Util.instance.teleportEntity(this.field_70170_p.func_73046_m(), (Entity)this, this.homeDimensionId, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
            catch (CommandException e) {
                LogWriter.error((Object)e);
            }
        }
        this.field_70138_W = this.ais.stepheight;
        this.lookPos[0] = 0.0f;
        this.lookPos[1] = 0.0f;
        EventHooks.onNPCInit(this);
    }

    public void reset(int delay) {
        CustomNPCsScheduler.runTack(this::reset, delay);
    }

    public void say(EntityPlayer player, Line line) {
        boolean isEmpty;
        if (line == null || !this.func_70635_at().func_75522_a((Entity)player)) {
            return;
        }
        if (!line.getSound().isEmpty()) {
            BlockPos pos = this.func_180425_c();
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.PLAY_SOUND, line.getSound(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Float.valueOf(this.func_70599_aP()), Float.valueOf(this.func_70647_i()));
        }
        if (!(isEmpty = line.getText().isEmpty())) {
            isEmpty = true;
            for (int i = 0; i < line.getText().length(); ++i) {
                if (line.getText().charAt(i) == ' ' && line.getText().charAt(i) == '\t') continue;
                isEmpty = false;
                break;
            }
        }
        if (!isEmpty) {
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.CHAT_BUBBLE, this.func_145782_y(), line.getText(), line.getShowText());
        }
    }

    public void saySurrounding(Line line) {
        if (line == null) {
            return;
        }
        if (line.getShowText() && !line.getText().isEmpty()) {
            ServerChatEvent event = new ServerChatEvent(this.getFakeChatPlayer(), line.getText(), (ITextComponent)new TextComponentTranslation(line.getText().replace("%", "%%"), new Object[0]));
            if (CustomNpcs.NpcSpeachTriggersChatEvent && (MinecraftForge.EVENT_BUS.post((Event)event) || event.getComponent() == null)) {
                return;
            }
            line.setText(event.getComponent().func_150260_c().replace("%%", "%"));
        }
        for (EntityPlayer player : Util.instance.getEntitiesWithinDist(EntityPlayer.class, this.field_70170_p, (Entity)this, 20.0)) {
            this.say(player, line);
        }
    }

    public void seekShelter() {
        if (this.ais.aiDisabled) {
            return;
        }
        if (this.ais.findShelter == 0) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIMoveIndoors(this));
        } else if (this.ais.findShelter == 1) {
            if (!this.canFly()) {
                this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
            }
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIFindShade(this));
        }
    }

    public void setPriorityAttackTarget(EntityLivingBase entityTarget) {
        if (!this.func_70089_S() || this.func_70638_az() == entityTarget || entityTarget instanceof EntityPlayer && ((EntityPlayer)entityTarget).field_71075_bZ.field_75102_a || entityTarget != null && entityTarget == this.getOwner() || entityTarget instanceof EntityNPCInterface && this.isFriend((Entity)entityTarget)) {
            return;
        }
        super.func_70624_b(entityTarget);
    }

    public void func_70624_b(EntityLivingBase entityTarget) {
        Line line;
        if (entityTarget != null && (entityTarget.field_70128_L || this.field_70170_p.func_73045_a(entityTarget.func_145782_y()) == null)) {
            entityTarget = null;
        }
        if (!this.func_70089_S() || this.func_70638_az() == entityTarget || entityTarget instanceof EntityPlayer && ((EntityPlayer)entityTarget).field_71075_bZ.field_75102_a || entityTarget != null && entityTarget == this.getOwner() || entityTarget instanceof EntityNPCInterface && this.isFriend((Entity)entityTarget)) {
            return;
        }
        if (entityTarget != null) {
            if (!entityTarget.func_70089_S()) {
                return;
            }
            if (this.func_70638_az() != null && this.combatHandler.priorityTarget != null) {
                return;
            }
            Object event = new NpcEvent.TargetEvent(this.wrappedNPC, (EntityLivingBase)entityTarget);
            if (EventHooks.onNPCTarget(this, event)) {
                return;
            }
            entityTarget = ((NpcEvent.TargetEvent)((Object)event)).entity == null ? null : ((NpcEvent.TargetEvent)((Object)event)).entity.getMCEntity();
            if (this.func_70638_az() == entityTarget || entityTarget instanceof EntityPlayer && ((EntityPlayer)entityTarget).field_71075_bZ.field_75102_a || entityTarget != null && entityTarget == this.getOwner() || entityTarget instanceof EntityNPCInterface && this.isFriend((Entity)entityTarget)) {
                return;
            }
        } else {
            for (EntityAITasks.EntityAITaskEntry en : this.field_70715_bh.field_75782_a) {
                if (!en.field_188524_c) continue;
                en.field_188524_c = false;
                en.field_75733_a.func_75251_c();
            }
            if (EventHooks.onNPCTargetLost(this, this.func_70638_az())) {
                return;
            }
        }
        if (entityTarget != null && entityTarget != this && this.ais.onAttack != 3 && !this.isAttacking() && this.func_70613_aW() && (line = this.advanced.getAttackLine()) != null) {
            this.saySurrounding(Line.formatTarget(line, entityTarget));
        }
        super.func_70624_b(entityTarget);
        this.updateTargetClient();
    }

    public void setCurrentAnimation(int animation) {
        this.currentAnimation = animation;
        this.field_70180_af.func_187227_b(Animation, (Object)animation);
        if (animation != 4 && this.aiAttackTarget instanceof EntityAICommanderTarget) {
            ((EntityAICommanderTarget)this.aiAttackTarget).baseAnimation = animation;
        }
        this.updateAnimationClient();
    }

    public void setDataWatcher(EntityDataManager dataManager) {
        this.field_70180_af = dataManager;
    }

    public void func_70106_y() {
        this.hasDied = true;
        this.func_184226_ay();
        this.func_184210_p();
        if (!this.func_70613_aW() || this.stats.spawnCycle == 3 || this.stats.spawnCycle == 4) {
            this.delete();
        } else {
            this.func_70606_j(-1.0f);
            this.func_70031_b(false);
            this.func_70661_as().func_75499_g();
            this.setCurrentAnimation(2);
            this.updateHitbox();
            if (this.killedTime <= 0L) {
                this.killedTime = (long)this.stats.respawnTime * 1000L + System.currentTimeMillis();
            }
            if (!this.ais.aiDisabled) {
                this.advanced.roleInterface.killed();
                this.advanced.jobInterface.killed();
            }
        }
    }

    public void setFaction(int id) {
        if (id < 0 || !this.func_70613_aW()) {
            return;
        }
        this.field_70180_af.func_187227_b(FactionData, (Object)id);
    }

    public void func_175449_a(@Nonnull BlockPos pos, int range) {
        super.func_175449_a(pos, range);
        this.ais.setStartPos(pos);
        this.updateClient = true;
    }

    public void setImmuneToFire(boolean immuneToFire) {
        this.field_70178_ae = immuneToFire;
        this.stats.immuneToFire = immuneToFire;
    }

    public void func_70110_aj() {
        if (!this.stats.ignoreCobweb) {
            super.func_70110_aj();
        }
    }

    public void func_184201_a(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack item) {
        if (slot == EntityEquipmentSlot.MAINHAND) {
            this.inventory.weapons.put(0, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(item));
        } else if (slot == EntityEquipmentSlot.OFFHAND) {
            this.inventory.weapons.put(2, Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(item));
        } else {
            this.inventory.armor.put(3 - slot.func_188454_b(), Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(item));
        }
    }

    public void setJobData(String s) {
        this.field_70180_af.func_187227_b(RoleData, (Object)s);
    }

    public void setMoveType() {
        if (this.ais.getMovingType() == 1) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIWander(this));
        }
        if (this.ais.getMovingType() == 2) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIMovingPath(this));
        }
    }

    public void func_181015_d(@Nonnull BlockPos pos) {
    }

    private void setResponse() {
        this.aiAttackTarget = null;
        this.aiIsSneak = false;
        this.aiOwnerNPC = null;
        if (this.ais.aiDisabled) {
            return;
        }
        if (this.ais.canSprint) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAISprintToTarget(this));
        }
        if (this.ais.onAttack == 2) {
            this.aiAttackTarget = new EntityAIAvoidTarget(this);
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.aiAttackTarget);
        } else if (this.ais.onAttack == 0) {
            if (this.ais.canLeap) {
                this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIPounceTarget(this));
            }
            switch (this.ais.tacticalVariant) {
                case 0: {
                    this.aiAttackTarget = new EntityAIOnslaught((IRangedAttackMob)this);
                    this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.aiAttackTarget);
                    break;
                }
                case 1: {
                    this.aiAttackTarget = new EntityAIDodge((IRangedAttackMob)this);
                    this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.aiAttackTarget);
                    break;
                }
                case 2: {
                    this.aiAttackTarget = new EntityAISurround((IRangedAttackMob)this);
                    this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.aiAttackTarget);
                    break;
                }
                case 3: {
                    this.aiAttackTarget = new EntityAIHitAndRun((IRangedAttackMob)this);
                    this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.aiAttackTarget);
                    break;
                }
                case 4: {
                    this.aiAttackTarget = new EntityAICommanderTarget((IRangedAttackMob)this);
                    this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.aiAttackTarget);
                    break;
                }
                case 5: {
                    this.aiAttackTarget = new EntityAIStalkTarget((IRangedAttackMob)this);
                    this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.aiAttackTarget);
                    break;
                }
                default: {
                    this.aiAttackTarget = new EntityAINoTactic((IRangedAttackMob)this);
                    this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.aiAttackTarget);
                }
            }
        }
    }

    public void setRoleData(String s) {
        this.field_70180_af.func_187227_b(RoleData, (Object)s);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public EntityProjectile shoot(double x, double y, double z, int accuracy, ItemStack proj, boolean indirect) {
        EntityProjectile projectile = new EntityProjectile(this.field_70170_p, (EntityLivingBase)this, proj.func_77946_l(), true);
        double varX = x - this.field_70165_t;
        double varY = y - (this.field_70163_u + (double)this.func_70047_e());
        double varZ = z - this.field_70161_v;
        float varF = projectile.hasGravity() ? MathHelper.func_76133_a((double)(varX * varX + varZ * varZ)) : 0.0f;
        float angle = projectile.getAngleForXYZ(varY, varF, indirect);
        float acc = 20.0f - (float)MathHelper.func_76141_d((float)((float)accuracy / 5.0f));
        projectile.func_70186_c(varX, varY, varZ, angle, acc);
        this.field_70170_p.func_72838_d((Entity)projectile);
        this.animation.tryRunAnimation(AnimationKind.SHOOT);
        if (this.animation.isAnimated(AnimationKind.AIM)) {
            this.animation.stopAnimation();
        }
        return projectile;
    }

    public EntityProjectile shoot(EntityLivingBase entity, int accuracy, ItemStack proj, boolean indirect) {
        return this.shoot(entity.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, accuracy, proj, indirect);
    }

    public boolean shouldDismountInWater(@Nonnull Entity rider) {
        return false;
    }

    public void tpTo(EntityLivingBase owner) {
        if (owner == null) {
            return;
        }
        EnumFacing facing = owner.func_174811_aO().func_176734_d();
        BlockPos pos = new BlockPos(owner.field_70165_t, owner.func_174813_aQ().field_72338_b, owner.field_70161_v);
        pos = pos.func_177982_a(facing.func_82601_c(), 0, facing.func_82599_e());
        pos = this.calculateTopPos(pos);
        block0: for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                BlockPos check = facing.func_82601_c() == 0 ? pos.func_177982_a(i, 0, j * facing.func_82599_e()) : pos.func_177982_a(j * facing.func_82601_c(), 0, i);
                if (this.field_70170_p.func_180495_p(check = this.calculateTopPos(check)).func_185913_b() || this.field_70170_p.func_180495_p(check.func_177984_a()).func_185913_b()) continue;
                this.func_70012_b((float)check.func_177958_n() + 0.5f, check.func_177956_o(), (float)check.func_177952_p() + 0.5f, this.field_70177_z, this.field_70125_A);
                this.func_70661_as().func_75499_g();
                continue block0;
            }
        }
    }

    public void func_191986_a(float f1, float f2, float f3) {
        double d0 = this.field_70165_t;
        double d2 = this.field_70163_u;
        double d3 = this.field_70161_v;
        super.func_191986_a(f1, f2, f3);
        if (this.ais.aiDisabled) {
            return;
        }
        if (this.advanced.roleInterface instanceof RoleCompanion && this.func_70613_aW()) {
            ((RoleCompanion)this.advanced.roleInterface).addMovementStat(this.field_70165_t - d0, this.field_70163_u - d2, this.field_70161_v - d3);
        }
    }

    public void updateAiClient() {
        if (!this.func_70613_aW() || this.aiAttackTarget == null) {
            return;
        }
        CustomNpcs.debugData.start((Object)this);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("EntityId", this.func_145782_y());
        this.aiAttackTarget.writeToClientNBT(compound);
        if (compound.func_150296_c().size() > 1) {
            Server.sendAssociatedData((Entity)this, EnumPacketClient.UPDATE_NPC_AI_TARGET, compound);
        }
        CustomNpcs.debugData.end((Object)this);
    }

    public void updateAnimationClient() {
        if (!this.func_70613_aW()) {
            return;
        }
        Server.sendToAll(CustomNpcs.Server, EnumPacketClient.UPDATE_NPC_ANIMATION, this.field_70170_p.field_73011_w.getDimension(), this.func_145782_y(), this.currentAnimation);
    }

    public void updateClient() {
        NBTTagCompound compound = this.writeSpawnData();
        compound.func_74768_a("EntityId", this.func_145782_y());
        Server.sendToAll(CustomNpcs.Server, EnumPacketClient.UPDATE_NPC, compound);
        this.updateClient = false;
        this.updateNavClient();
    }

    public void updateHitbox() {
        double n;
        float w = this.baseWidth;
        float h = this.baseHeight;
        float eh = this.baseEyeHeight;
        if (this.display.width != 0.0f || this.display.height != 0.0f) {
            w = this.display.width;
            h = this.display.height;
        }
        if ((this.currentAnimation == AnimationType.SLEEP.get() || this.currentAnimation == AnimationType.CRAWL.get()) && !this.isAttacking() || this.field_70725_aQ > 0) {
            this.field_70130_N = w / 0.75f;
            this.field_70131_O = h / 4.75f;
            this.eyeHeight = eh / 4.75f;
        } else if (this.func_184218_aH() || this.func_70093_af()) {
            this.field_70130_N = w;
            this.field_70131_O = h / 1.3f;
            this.eyeHeight = eh / 1.3f;
        } else {
            this.field_70130_N = w;
            this.field_70131_O = h;
            this.eyeHeight = eh;
        }
        if (this.display.getModel() == null && this instanceof EntityCustomNpc) {
            ModelData modeldata = ((EntityCustomNpc)this).modelData;
            ModelPartConfig model = modeldata.getPartConfig(EnumParts.HEAD);
            float scaleHead = Math.max(model.scale[0], model.scale[2]);
            model = modeldata.getPartConfig(EnumParts.BODY);
            float scaleBody = Math.max(model.scale[0], model.scale[2]);
            this.field_70130_N *= Math.max(scaleHead, scaleBody);
            this.field_70130_N = this.field_70130_N / 5.0f * (float)this.display.getSize();
            this.field_70131_O = this.field_70131_O / 5.0f * (float)this.display.getSize();
            this.eyeHeight = this.eyeHeight / 5.0f * (float)this.display.getSize();
        }
        if ((n = (double)(this.field_70130_N / 2.0f)) > World.MAX_ENTITY_RADIUS) {
            World.MAX_ENTITY_RADIUS = n;
        }
        if (this.func_110143_aJ() == 0.0f) {
            return;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void updateNavClient() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("EntityId", this.func_145782_y());
        compound.func_74757_a("IsNavigating", this.navigating != null);
        if (this.navigating != null) {
            compound.func_74782_a("Navigating", (NBTBase)Server.writePathToNBT(this.navigating));
        }
        Server.sendAssociatedData((Entity)this, EnumPacketClient.UPDATE_NPC_NAVIGATION, compound);
    }

    public void updateTargetClient() {
        if (!this.func_70613_aW()) {
            return;
        }
        CustomNpcs.debugData.start((Object)this);
        Server.sendAssociatedData((Entity)this, EnumPacketClient.UPDATE_NPC_TARGET, this.func_145782_y(), this.func_70638_az() != null ? this.func_70638_az().func_145782_y() : -1);
        CustomNpcs.debugData.end((Object)this);
    }

    private void updateTasks() {
        if (!this.func_70613_aW()) {
            return;
        }
        this.clearTasks(this.field_70714_bg);
        this.clearTasks(this.field_70715_bh);
        if (this.isKilled()) {
            return;
        }
        NPCAttackSelector attackEntitySelector = new NPCAttackSelector(this);
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIClearTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIClosestTarget(this, 4, this.ais.directLOS, false, attackEntitySelector));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIOwnerHurtTarget(this));
        PathWorldListener pwl = WorldReflection.getPathListener(this.field_70170_p);
        if (pwl != null) {
            pwl.func_72709_b((Entity)this);
        }
        if (this.ais.movementType == 1) {
            this.field_70765_h = new FlyingMoveHelper(this);
            this.field_70699_by = new PathNavigateFlying((EntityLiving)this, this.field_70170_p);
        } else if (this.ais.movementType == 2) {
            this.field_70765_h = new FlyingMoveHelper(this);
            this.field_70699_by = new PathNavigateSwimmer((EntityLiving)this, this.field_70170_p);
        } else {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateGround((EntityLiving)this, this.field_70170_p);
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWaterNav(this));
        }
        if (pwl != null) {
            pwl.func_72703_a((Entity)this);
        }
        this.taskCount = 1;
        this.addRegularEntries();
        this.doorInteractType();
        this.seekShelter();
        this.setResponse();
        this.setMoveType();
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.display.writeToNBT(compound);
        this.stats.writeToNBT(compound);
        this.ais.writeToNBT(compound);
        this.script.writeToNBT(compound);
        this.timers.writeToNBT(compound);
        this.advanced.save(compound);
        this.inventory.writeEntityToNBT(compound);
        this.transform.save(compound);
        this.animation.save(compound);
        compound.func_74772_a("KilledTime", this.killedTime);
        compound.func_74772_a("TotalTicksAlive", this.totalTicksAlive);
        compound.func_74768_a("ModRev", this.npcVersion);
        compound.func_74778_a("LinkedNpcName", this.linkedName);
        compound.func_74768_a("HomeDimensionId", this.homeDimensionId);
    }

    public NBTTagCompound writeSpawnData() {
        NBTTagCompound compound = new NBTTagCompound();
        this.display.writeToNBT(compound);
        this.advanced.save(compound);
        this.animation.save(compound);
        compound.func_74768_a("NPCLevel", this.stats.getLevel());
        compound.func_74768_a("NPCRarity", this.stats.getRarity());
        compound.func_74778_a("NPCRarityTitle", this.stats.getRarityTitle());
        compound.func_74780_a("MaxHealth", this.stats.maxHealth);
        compound.func_74757_a("DeadBody", this.stats.hideKilledBody);
        compound.func_74768_a("AggroRange", this.stats.aggroRange);
        compound.func_74782_a("Armor", (NBTBase)NBTTags.nbtIItemStackMap(this.inventory.armor));
        compound.func_74782_a("Weapons", (NBTBase)NBTTags.nbtIItemStackMap(this.inventory.weapons));
        compound.func_74768_a("Speed", this.ais.getWalkingSpeed());
        compound.func_74768_a("CurrentAnimation", this.currentAnimation);
        compound.func_74768_a("StandingState", this.ais.getStandingType());
        compound.func_74768_a("MovingState", this.ais.getMovingType());
        compound.func_74768_a("Orientation", this.ais.orientation);
        compound.func_74776_a("PositionXOffset", this.ais.bodyOffsetX);
        compound.func_74776_a("PositionYOffset", this.ais.bodyOffsetY);
        compound.func_74776_a("PositionZOffset", this.ais.bodyOffsetZ);
        if (this.advanced.jobInterface instanceof JobBard) {
            NBTTagCompound bard = compound.func_74775_l("Bard");
            this.advanced.jobInterface.save(bard);
            compound.func_74782_a("Bard", (NBTBase)bard);
        }
        if (this.advanced.jobInterface instanceof JobFollower) {
            NBTTagCompound follower = compound.func_74775_l("Companion");
            this.advanced.jobInterface.save(follower);
            compound.func_74782_a("Companion", (NBTBase)follower);
        }
        if (this instanceof EntityCustomNpc) {
            compound.func_74782_a("ModelData", (NBTBase)((EntityCustomNpc)this).modelData.save());
        }
        this.isKilled();
        compound.func_74757_a("IsDead", ((Boolean)this.field_70180_af.func_187225_a(IsDead)).booleanValue());
        compound.func_74768_a("DeathTime", this.field_70725_aQ);
        NBTTagList lookPosList = new NBTTagList();
        lookPosList.func_74742_a((NBTBase)new NBTTagFloat(this.lookPos[0]));
        lookPosList.func_74742_a((NBTBase)new NBTTagFloat(this.lookPos[1]));
        compound.func_74782_a("LookPos", (NBTBase)lookPosList);
        this.updateHitbox();
        compound.func_74776_a("BaseWidth", this.baseWidth);
        compound.func_74776_a("BaseHeight", this.baseHeight);
        compound.func_74776_a("Width", this.field_70130_N);
        compound.func_74776_a("Height", this.field_70131_O);
        return compound;
    }

    public void writeSpawnData(ByteBuf buffer) {
        try {
            Server.writeNBT(buffer, this.writeSpawnData());
        }
        catch (IOException e) {
            LogWriter.error(e);
        }
    }

    public float func_70047_e() {
        return this.eyeHeight;
    }

    public void addRidingEntity(Entity entity) {
        if (!this.hitboxRiding.containsKey(entity) && this.display.getHitboxState() == 2 && !this.func_184196_w(entity) && Math.abs(entity.func_174813_aQ().field_72338_b - this.func_174813_aQ().field_72337_e) < 0.1) {
            this.hitboxRiding.put(entity, new double[]{this.field_70165_t - entity.field_70165_t, this.field_70161_v - entity.field_70161_v});
        }
    }

    public void func_180430_e(float distance, float modifier) {
        for (Entity entity : this.hitboxRiding.keySet()) {
            entity.func_180430_e(distance, modifier);
        }
        if (!this.stats.noFallDamage || this.advanced.roleInterface.getEnumType() == RoleType.FOLLOWER && this.advanced.roleInterface.isFollowing()) {
            return;
        }
        super.func_180430_e(distance, modifier);
    }

    static {
        ChatEventProfile = new GameProfileAlt();
        CommandProfile = new GameProfileAlt();
        GenericProfile = new GameProfileAlt();
        Animation = EntityDataManager.func_187226_a(EntityNPCInterface.class, (DataSerializer)DataSerializers.field_187192_b);
        Attacking = EntityDataManager.func_187226_a(EntityNPCInterface.class, (DataSerializer)DataSerializers.field_187198_h);
        FactionData = EntityDataManager.func_187226_a(EntityNPCInterface.class, (DataSerializer)DataSerializers.field_187192_b);
        Interacting = EntityDataManager.func_187226_a(EntityNPCInterface.class, (DataSerializer)DataSerializers.field_187198_h);
        IsDead = EntityDataManager.func_187226_a(EntityNPCInterface.class, (DataSerializer)DataSerializers.field_187198_h);
        JobData = EntityDataManager.func_187226_a(EntityNPCInterface.class, (DataSerializer)DataSerializers.field_187194_d);
        RoleData = EntityDataManager.func_187226_a(EntityNPCInterface.class, (DataSerializer)DataSerializers.field_187194_d);
        Walking = EntityDataManager.func_187226_a(EntityNPCInterface.class, (DataSerializer)DataSerializers.field_187198_h);
        AimRotationYaw = EntityDataManager.func_187226_a(EntityNPCInterface.class, (DataSerializer)DataSerializers.field_187193_c);
    }
}

